/*
 * Decompiled with CFR 0.152.
 */
package SpeechPkg;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;

public class WinSpeech {
    private static final String DLLNAME = "SystemSpeechNET.dll";
    private static NETDLL INSTANCE = null;
    private static String JNA_CODENAME = "shift_jis";
    private static HashMap<String, String> encodeMap;
    public static final boolean GRAMMAR = true;
    public static final boolean DICTATION = false;
    public static final boolean SINGLE = true;
    public static final boolean MULTIPLE = false;

    private void MapInit(String def) {
        encodeMap = new HashMap();
        encodeMap.put("EUC_JP", "EUC-JP");
        encodeMap.put("EUC-JP", "EUC-JP");
        encodeMap.put("SJIS", "shift_jis");
        encodeMap.put("Shift_JIS", "shift_jis");
        encodeMap.put("MS932", "shift_jis");
        encodeMap.put("windows-31j", "shift_jis");
        encodeMap.put("EUC_JP_LINUX", "EUC-JP");
        encodeMap.put("x-euc-jp-linux", "EUC-JP");
        encodeMap.put("EUC_JP_Solaris", "EUC-JP");
        encodeMap.put("x-eucJP-Open", "EUC-JP");
        encodeMap.put("UTF8", "utf-8");
        encodeMap.put("UTF-8", "utf-8");
        encodeMap.put("UTF-16", "utf-16");
        encodeMap.put("UnicodeBigUnmarked", "unicodeFFFE");
        encodeMap.put("UTF-16BE", "unicodeFFFE");
        encodeMap.put("UnicodeLittleUnmarked", "utf-16");
        encodeMap.put("UTF-16LE", "utf-16");
        encodeMap.put("UnicodeBig", "unicodeFFFE");
        encodeMap.put("UnicodeLittle", "utf-16");
    }

    public WinSpeech(String libPath) throws IllegalArgumentException, UnsatisfiedLinkError {
        Path driveName;
        String currentPath;
        String systemEncod = System.getProperty("file.encoding");
        this.MapInit(systemEncod);
        String csEncode = encodeMap.get(systemEncod);
        if (csEncode == null) {
            csEncode = systemEncod;
        }
        if (!csEncode.equals(JNA_CODENAME)) {
            System.setProperty("jna.encoding", JNA_CODENAME);
        }
        if ((currentPath = new File(libPath).getPath()).equals((driveName = FileSystems.getDefault().getPath(currentPath, new String[0]).getRoot()).toString())) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30b9\u306b\u30c9\u30e9\u30a4\u30d6\u540d\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093:" + libPath);
        }
        if (!new File(libPath).exists()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30b9\u306bDLL\u304c\u5b58\u5728\u3057\u307e\u305b\u3093:" + libPath);
        }
        NativeLibrary.addSearchPath(DLLNAME, libPath);
        INSTANCE = Native.load(DLLNAME, NETDLL.class);
        INSTANCE.SetLogEncode(csEncode, currentPath);
    }

    public WinSpeech() throws IllegalArgumentException, UnsatisfiedLinkError {
        String path = new File(".").getAbsoluteFile().getParent();
        new WinSpeech(path);
    }

    public void SetLogName(String fileName) {
        if (fileName != null && !fileName.equals("")) {
            INSTANCE.SetLogName(fileName);
        } else {
            System.err.println("SetLogName error");
        }
    }

    public void SetGrammarName(String fileName) {
        if (fileName != null && !fileName.equals("")) {
            INSTANCE.SetGrammarName(fileName);
        } else {
            System.err.println("SetGrammarName error");
        }
    }

    public void SetLogSwitch(boolean logSw) {
        INSTANCE.SetLogSwitch(logSw);
    }

    public void CloseEngine() {
        INSTANCE.CloseEngine();
    }

    public int OpenEngine(boolean mode) {
        int ret = INSTANCE.OpenEngine(mode);
        if (ret != 0) {
            System.err.println("OpenEngine error:" + ret);
            return ret;
        }
        return 0;
    }

    public int OpenEngine() {
        return this.OpenEngine(false);
    }

    public int SetDictationType(boolean mode) {
        int ret = INSTANCE.SetDictationType(mode);
        if (ret != 0) {
            System.err.println("SetDictationType error:" + ret);
            return ret;
        }
        return 0;
    }

    public int SetInputDefaultAudio() {
        int ret = INSTANCE.SetInputDefaultAudio();
        if (ret != 0) {
            System.err.println("SetInputDefaultAudio error:" + ret);
            return ret;
        }
        return 0;
    }

    public int SetInputWavFile(String fileName) {
        int ret = INSTANCE.SetInputWavFile(fileName);
        if (ret != 0) {
            System.err.println("SetInputWavFile error:" + ret);
            return ret;
        }
        return 0;
    }

    public int StartAsyncRecognized(boolean mode) {
        int ret = INSTANCE.StartAsyncRecognized(mode);
        if (ret != 0) {
            System.err.println("StartAsyncRecognized error:" + ret);
            return ret;
        }
        return 0;
    }

    public int StartRecognized(int timeOut) {
        int ret = INSTANCE.StartRecognized(timeOut);
        if (ret != 0) {
            System.err.println("StartRecognized error:" + ret);
            return ret;
        }
        return 0;
    }

    public int StopAsyncRecognized() {
        int ret = INSTANCE.StopAsyncRecognized();
        if (ret != 0) {
            System.err.println("StopAsyncRecognized error:" + ret);
            return ret;
        }
        return 0;
    }

    public String GetSpeechRecognized() {
        return INSTANCE.GetSpeechRecognized();
    }

    public String GetSpeechHypothesized() {
        return INSTANCE.GetSpeechHypothesized();
    }

    public void SetHypothesizedCallBackFunc(final Object obj, String func) {
        Class<?> clazz = obj.getClass();
        try {
            final Method p5Func = clazz.getMethod(func, String.class, Float.TYPE);
            INSTANCE.SetHypothesizedCallBackFunc(new CallBackHypothesizedFunc(){

                @Override
                public void invoke(PointerByReference data, FloatByReference confidence) {
                    Pointer p = data.getValue();
                    float conf = confidence.getValue();
                    String buffer = p.getString(0L);
                    try {
                        if (p5Func != null) {
                            p5Func.invoke(obj, buffer, Float.valueOf(conf));
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return;
        }
    }

    public void SetCallbackRecognizedFunc(final Object obj, String func) {
        Class<?> clazz = obj.getClass();
        try {
            final Method p5Func = clazz.getMethod(func, String.class);
            INSTANCE.SetRecognizedCallbackFunc(new CallBackRecognizedFunc(){

                @Override
                public void invoke(PointerByReference data, IntByReference size) {
                    Pointer p = data.getValue();
                    String buffer = p.getString(0L);
                    try {
                        if (p5Func != null) {
                            p5Func.invoke(obj, buffer);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return;
        }
    }

    private static interface CallBackRecognizedFunc
    extends Callback {
        public void invoke(PointerByReference var1, IntByReference var2);
    }

    private static interface CallBackHypothesizedFunc
    extends Callback {
        public void invoke(PointerByReference var1, FloatByReference var2);
    }

    static interface NETDLL
    extends Library {
        public void SetLogEncode(String var1, String var2);

        public void SetLogName(String var1);

        public void SetGrammarName(String var1);

        public void SetLogSwitch(boolean var1);

        public void CloseEngine();

        public int OpenEngine(boolean var1);

        public int SetDictationType(boolean var1);

        public int SetInputDefaultAudio();

        public int SetInputWavFile(String var1);

        public int StartAsyncRecognized(boolean var1);

        public int StartRecognized(int var1);

        public int StopAsyncRecognized();

        public String GetSpeechRecognized();

        public String GetSpeechHypothesized();

        public void SetHypothesizedCallBackFunc(CallBackHypothesizedFunc var1);

        public void SetRecognizedCallbackFunc(CallBackRecognizedFunc var1);
    }
}

