package ZxingP5Test;

import java.util.ArrayList;

import ZxingP5.CodeReader;
import ZxingP5.CodeWriter;
import ZxingP5.EANReader;
import ZxingP5.EANWriter;
import ZxingP5.ITFP5Reader;
import ZxingP5.ITFP5Writer;
import ZxingP5.NW7Reader;
import ZxingP5.NW7Writer;
import ZxingP5.QRReader;
import ZxingP5.QRWriter;
import ZxingP5.ZxingP5Com;
import processing.core.PApplet;
import processing.core.PImage;

public class TextZxingP5 extends PApplet {

	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ
		PApplet.main( new String[] { TextZxingP5.class.getName() } );
	}

	CodeWriter    codeWriter;
	CodeReader    codeReader;
	EANWriter     eanWriter;
	EANReader     eanReader;
	ITFP5Writer   itfWriter;
	ITFP5Reader   itfReader;
	NW7Writer     nw7Writer;
	NW7Reader     nw7Reader;
	QRWriter      qrWriter;
	QRReader      qrReader;


	PImage        pImage;
	ArrayList<String>	codeTxt = new ArrayList<String>();

	//初期処理関数
	  @Override
	public
	  void settings() {
	    //size()命令やsmooth()命令は、ここで使う
		  size(400,400);
	  }

	  @Override
	public
	  void setup() {
		  size(400,400);
		  //ログ出力指定
		  ZxingP5Com.setLogoutOn(dataPath("") + "\\logfile.log" );

		  //インスタンス作成
		  codeWriter = new CodeWriter(this);
		  eanWriter = new EANWriter(this);
		  itfWriter = new ITFP5Writer(this);
		  nw7Writer = new NW7Writer(this);
		  qrWriter = new QRWriter(this);

		  codeReader = new CodeReader(this);
		  eanReader = new EANReader(this);
		  itfReader = new ITFP5Reader(this);
		  nw7Reader = new NW7Reader(this);
		  qrReader = new QRReader(this);


		  String text = "";

		  //画像化
 		  pImage = codeWriter.encode39("123Hello", 0, 50, true, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\code39Sample.png");
		  text = codeReader.decode39(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "CODE39:" + text );
		  }

		  pImage = codeWriter.encode128("123Hello", 0, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\code128Sample.png");
		  text = codeReader.decode128(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "CODE128:" + text );
		  }

		  pImage = eanWriter.encode8("45034567", 0, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\ean8Sample.png");
		  text = eanReader.decode8(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "EAN8:" + text );
		  }

		  pImage = eanWriter.encode13("4953456789012", 0, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\ean13Sample.png");
		  text = eanReader.decode13(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "EAN13:" + text );
		  }

		  pImage = itfWriter.encode("012345", 90, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\itf6Sample.png");
		  text = itfReader.decode(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "ITF6:" + text );
		  }

		  pImage = itfWriter.encode("01234567890123", 160, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\itf14Sample.png");
		  text = itfReader.decode(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "ITF14:" + text );
		  }

		  pImage = itfWriter.encode("0123456789012345", 180, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\itf16Sample.png");
		  text = itfReader.decode(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "ITF16:" + text );
		  }

		  pImage = nw7Writer.encode("A1234A", 0, 50, true);
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\nw7Sample.png");
		  text = nw7Reader.decode(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "NW7:" + text );
		  }

		  pImage = qrWriter.encode("ZxingP5ライブラリのサンプルです。");
		  ZxingP5Com.saveBarCodeImage(pImage, dataPath("") + "\\qrSample.png");
		  text =  qrReader.decode(pImage, true, false);
		  if( text != null ) {
			  codeTxt.add( "QR-CODE:" + text );
		  }

	  }

	  //描画処理関数
	  @Override
	  public void draw() {
		  background(255);

		  int putY = 0;
		  textSize(24);
		  textAlign(LEFT, TOP);
		  fill(0);

		  for( String Text : codeTxt ) {
			  text( Text, 0, putY );
			  putY = putY + 26;
		  }
	  }
}
