/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.EANReader;
import ZxingP5.NW7Reader;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.imageio.ImageIO;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;

public final class ZxingP5Com {
    public static final String VERSION = "1.0.0";
    static boolean logMode = false;
    static FileWriter logWriter = null;
    static File canonPath = null;

    static String getSuffix(String fileName) {
        if (fileName == null) {
            return null;
        }
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(point + 1).toLowerCase();
        }
        ZxingP5Com.logout("\u62e1\u5f35\u5b50\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
        return null;
    }

    public static void setLogoutOn(String fileName) {
        if (ZxingP5Com.getSuffix(fileName) == null) {
            fileName = String.valueOf(fileName) + "." + ".log";
        }
        File outputFile = new File(fileName);
        try {
            canonPath = new File(outputFile.getCanonicalPath());
        }
        catch (IOException e) {
            logMode = false;
            return;
        }
        File folder = new File(canonPath.getParent());
        if (!folder.exists()) {
            logMode = false;
            return;
        }
        logMode = true;
    }

    public static void setLogoutOff() {
        logMode = false;
    }

    public static boolean getLogout() {
        return logMode;
    }

    static void logout(String src) {
        if (!logMode) {
            return;
        }
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String className = ste[2].getClassName();
        String mtoName = ste[2].getMethodName();
        LocalDateTime ldt = LocalDateTime.now();
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss SSS");
        String localStr = dtf1.format(ldt);
        try {
            logWriter = new FileWriter(canonPath, true);
            PrintWriter pw = new PrintWriter(logWriter);
            pw.format("%s [%s:%s]:%s\r\n", localStr, className, mtoName, src);
            pw.close();
            logWriter.close();
        }
        catch (IOException e) {
            logMode = false;
            return;
        }
    }

    public static boolean saveBarCodeImage(PImage pImage, String fileName) {
        if (fileName == null || fileName.length() < 1) {
            ZxingP5Com.logout(String.format("fileName\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059", new Object[0]));
            return false;
        }
        if (pImage == null) {
            ZxingP5Com.logout(String.format("pImage\u304cnull\u3067\u3059", new Object[0]));
            return false;
        }
        boolean ret = ZxingP5Com.saveBarCodeImage((BufferedImage)pImage.getNative(), fileName);
        return ret;
    }

    static boolean saveBarCodeImage(BufferedImage img, String fileName) {
        String formatName = "png";
        File outputFile = null;
        if (ZxingP5Com.getSuffix(fileName) == null) {
            fileName = String.valueOf(fileName) + "." + formatName;
        }
        outputFile = new File(fileName);
        File canonPath = null;
        try {
            canonPath = new File(outputFile.getCanonicalPath());
        }
        catch (IOException e) {
            ZxingP5Com.logout(String.format("%s \u306e\u7d76\u5bfe\u30d1\u30b9\u53d6\u5f97\u3067 IOException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return false;
        }
        File folder = new File(canonPath.getParent());
        if (!folder.exists()) {
            ZxingP5Com.logout(String.format("%s \u304c\u5b58\u5728\u3057\u307e\u305b\u3093", folder));
            return false;
        }
        try {
            ImageIO.write((RenderedImage)img, formatName, canonPath);
        }
        catch (IOException e) {
            ZxingP5Com.logout(String.format("%s \u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3067 IOException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return false;
        }
        return true;
    }

    static PImage codeImageRotate(PApplet app, PImage pImage, int degree) {
        if (degree == 0 || degree == 360) {
            return pImage;
        }
        int longLen = 0;
        longLen = pImage.width > pImage.height ? (int)((double)pImage.width * 1.42) : (int)((double)pImage.height * 1.42);
        PGraphics g = app.createGraphics(longLen, longLen);
        g.beginDraw();
        g.background(255);
        g.pushMatrix();
        g.translate((float)(longLen / 2), (float)(longLen / 2));
        g.rotate(PApplet.radians((float)degree));
        g.imageMode(3);
        g.image(pImage, 0.0f, 0.0f);
        g.imageMode(0);
        g.popMatrix();
        g.endDraw();
        PImage img = g.get();
        img.save(String.valueOf(app.dataPath("")) + "\\rotate" + String.valueOf(degree) + ".png");
        return img;
    }

    static BinaryBitmap changePImage2Bitmap(PImage pImage, boolean globalHistogram) {
        BufferedImage buf = (BufferedImage)pImage.getNative();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(buf);
        BinaryBitmap bitmap = null;
        bitmap = globalHistogram ? new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source)) : new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        return bitmap;
    }

    static PImage resizeImage(PImage src, int width, int height) {
        if (width < 1 || height < 1) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306f1\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 width = %d  height = %d", width, height));
            return null;
        }
        Image jImage = src.getImage();
        Image scaledImg = null;
        try {
            scaledImg = jImage.getScaledInstance(width, height, 4);
        }
        catch (IllegalArgumentException e) {
            ZxingP5Com.logout(String.format("\u62e1\u5927\u7e2e\u5c0f\u51e6\u7406\u3067 IllegalArgumentException \u4f8b\u5916\u767a\u751f width = %d  height = %d", width, height));
            return null;
        }
        return new PImage(scaledImg);
    }

    static PImage changeBitMatrix2PImage(BitMatrix bitMatrix) {
        BufferedImage bImg = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        return new PImage((Image)bImg);
    }

    static PVector[] getPoints(Result result) {
        if (result == null) {
            ZxingP5Com.logout(String.format("Result\u304c\u3042\u308a\u307e\u305b\u3093\u3002", new Object[0]));
            return null;
        }
        ResultPoint[] resultPoints = result.getResultPoints();
        PVector[] points = new PVector[resultPoints.length];
        int i = 0;
        while (i < resultPoints.length) {
            points[i] = new PVector(resultPoints[i].getX(), resultPoints[i].getY());
            ++i;
        }
        return points;
    }

    static boolean checkQRParam(String src, ErrorCorrectionLevel ecLevel, int version) {
        if (1 > version || version > 40) {
            ZxingP5Com.logout(String.format("version\u306f1\u304b\u308940\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002version = %d", version));
            return false;
        }
        int getVer = ZxingP5Com.getQrVersion(src, ecLevel);
        if (getVer == 0 || getVer > version) {
            ZxingP5Com.logout(String.format("\u5909\u63db\u5bfe\u8c61\u6587\u5b57\u5217\u3068\u8aa4\u308a\u8a02\u6b63\u7387\u306b\u898b\u5408\u3046\u9069\u5207\u306aQR\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u5f97\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u6587\u5b57\u5217\u9577 = %d  \u8aa4\u308a\u8a02\u6b63\u7387 = %s", src.length(), ecLevel));
            return false;
        }
        return true;
    }

    static int getQrVersion(String src, ErrorCorrectionLevel ecLevel) {
        if (src == null || src.length() < 1) {
            ZxingP5Com.logout(String.format("\u5909\u63db\u5bfe\u8c61\u6587\u5b57\u5217\u304c\u4e0d\u6b63\u3067\u3059\u3002", new Object[0]));
            return 0;
        }
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(1, new int[]{10, 8, 7, 4});
        map.put(2, new int[]{20, 16, 12, 8});
        map.put(3, new int[]{32, 26, 20, 15});
        map.put(4, new int[]{148, 38, 28, 21});
        map.put(5, new int[]{65, 52, 37, 27});
        map.put(6, new int[]{82, 65, 45, 36});
        map.put(7, new int[]{95, 75, 53, 39});
        map.put(8, new int[]{118, 93, 66, 52});
        map.put(9, new int[]{141, 111, 80, 60});
        map.put(10, new int[]{167, 131, 93, 74});
        map.put(11, new int[]{198, 155, 109, 85});
        map.put(12, new int[]{226, 177, 125, 96});
        map.put(13, new int[]{262, 204, 149, 109});
        map.put(14, new int[]{282, 223, 159, 120});
        map.put(15, new int[]{320, 254, 180, 136});
        map.put(16, new int[]{361, 277, 198, 154});
        map.put(17, new int[]{397, 310, 224, 173});
        map.put(18, new int[]{442, 345, 243, 191});
        map.put(19, new int[]{488, 384, 272, 208});
        map.put(20, new int[]{528, 410, 297, 235});
        map.put(21, new int[]{572, 438, 314, 248});
        map.put(22, new int[]{618, 480, 348, 270});
        map.put(23, new int[]{672, 528, 376, 284});
        map.put(24, new int[]{721, 561, 407, 315});
        map.put(25, new int[]{784, 614, 440, 330});
        map.put(26, new int[]{842, 652, 462, 365});
        map.put(27, new int[]{902, 692, 496, 385});
        map.put(28, new int[]{940, 732, 534, 405});
        map.put(29, new int[]{1002, 778, 559, 430});
        map.put(30, new int[]{1066, 843, 604, 457});
        map.put(31, new int[]{1132, 894, 634, 486});
        map.put(32, new int[]{1201, 947, 684, 518});
        map.put(33, new int[]{1273, 1002, 719, 553});
        map.put(34, new int[]{1347, 1060, 756, 590});
        map.put(35, new int[]{1417, 1113, 790, 605});
        map.put(36, new int[]{1496, 1176, 832, 647});
        map.put(37, new int[]{1577, 1224, 876, 673});
        map.put(38, new int[]{1661, 1292, 923, 701});
        map.put(39, new int[]{1729, 1362, 972, 750});
        map.put(40, new int[]{1817, 1435, 1024, 784});
        int foundVersion = 0;
        Integer version = 1;
        while (version < 41) {
            int[] datas = (int[])map.get(version);
            int index = 0;
            if (ecLevel == ErrorCorrectionLevel.L) {
                index = 0;
            } else if (ecLevel == ErrorCorrectionLevel.M) {
                index = 1;
            } else if (ecLevel == ErrorCorrectionLevel.Q) {
                index = 2;
            } else if (ecLevel == ErrorCorrectionLevel.H) {
                index = 3;
            }
            if (datas[index] >= src.length()) {
                foundVersion = version;
                break;
            }
            version = version + 1;
        }
        return foundVersion;
    }

    static boolean checkEANParam(BarcodeFormat format, String src, int width, int height) {
        if (width < 0 || height < 0) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306f0\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002width = %d  height = %d", width, height));
            return false;
        }
        if (format != BarcodeFormat.EAN_13 && format != BarcodeFormat.EAN_8) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002", new Object[0]));
            return false;
        }
        if (format == BarcodeFormat.EAN_13) {
            if (!src.matches("[0-9]{12,13}")) {
                ZxingP5Com.logout(String.format("EAN13\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308b\u304b\u3001\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002src = %s", src));
                return false;
            }
        } else if (format == BarcodeFormat.EAN_8 && !src.matches("[0-9]{7,8}")) {
            ZxingP5Com.logout(String.format("EAN8\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308b\u304b\u3001\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002src = %s", src));
            return false;
        }
        int country = Integer.valueOf(src.substring(0, 3));
        int[] nArray = new int[242];
        nArray[1] = 9;
        nArray[2] = 30;
        nArray[3] = 39;
        nArray[4] = 50;
        nArray[5] = 59;
        nArray[6] = 60;
        nArray[7] = 139;
        nArray[8] = 200;
        nArray[9] = 299;
        nArray[10] = 300;
        nArray[11] = 379;
        nArray[12] = 380;
        nArray[13] = 380;
        nArray[14] = 383;
        nArray[15] = 383;
        nArray[16] = 385;
        nArray[17] = 385;
        nArray[18] = 387;
        nArray[19] = 387;
        nArray[20] = 389;
        nArray[21] = 389;
        nArray[22] = 400;
        nArray[23] = 440;
        nArray[24] = 450;
        nArray[25] = 459;
        nArray[26] = 490;
        nArray[27] = 499;
        nArray[28] = 460;
        nArray[29] = 469;
        nArray[30] = 470;
        nArray[31] = 470;
        nArray[32] = 471;
        nArray[33] = 471;
        nArray[34] = 474;
        nArray[35] = 474;
        nArray[36] = 475;
        nArray[37] = 475;
        nArray[38] = 476;
        nArray[39] = 476;
        nArray[40] = 477;
        nArray[41] = 477;
        nArray[42] = 478;
        nArray[43] = 478;
        nArray[44] = 479;
        nArray[45] = 479;
        nArray[46] = 480;
        nArray[47] = 480;
        nArray[48] = 481;
        nArray[49] = 481;
        nArray[50] = 482;
        nArray[51] = 482;
        nArray[52] = 484;
        nArray[53] = 484;
        nArray[54] = 485;
        nArray[55] = 485;
        nArray[56] = 486;
        nArray[57] = 486;
        nArray[58] = 487;
        nArray[59] = 487;
        nArray[60] = 488;
        nArray[61] = 488;
        nArray[62] = 489;
        nArray[63] = 489;
        nArray[64] = 500;
        nArray[65] = 509;
        nArray[66] = 520;
        nArray[67] = 520;
        nArray[68] = 521;
        nArray[69] = 521;
        nArray[70] = 528;
        nArray[71] = 528;
        nArray[72] = 529;
        nArray[73] = 529;
        nArray[74] = 530;
        nArray[75] = 530;
        nArray[76] = 531;
        nArray[77] = 531;
        nArray[78] = 535;
        nArray[79] = 535;
        nArray[80] = 539;
        nArray[81] = 539;
        nArray[82] = 540;
        nArray[83] = 549;
        nArray[84] = 560;
        nArray[85] = 560;
        nArray[86] = 569;
        nArray[87] = 569;
        nArray[88] = 570;
        nArray[89] = 579;
        nArray[90] = 590;
        nArray[91] = 590;
        nArray[92] = 594;
        nArray[93] = 594;
        nArray[94] = 599;
        nArray[95] = 599;
        nArray[96] = 600;
        nArray[97] = 601;
        nArray[98] = 603;
        nArray[99] = 603;
        nArray[100] = 604;
        nArray[101] = 604;
        nArray[102] = 608;
        nArray[103] = 608;
        nArray[104] = 609;
        nArray[105] = 609;
        nArray[106] = 611;
        nArray[107] = 611;
        nArray[108] = 613;
        nArray[109] = 613;
        nArray[110] = 615;
        nArray[111] = 615;
        nArray[112] = 616;
        nArray[113] = 616;
        nArray[114] = 618;
        nArray[115] = 618;
        nArray[116] = 619;
        nArray[117] = 619;
        nArray[118] = 621;
        nArray[119] = 621;
        nArray[120] = 622;
        nArray[121] = 622;
        nArray[122] = 624;
        nArray[123] = 624;
        nArray[124] = 625;
        nArray[125] = 625;
        nArray[126] = 626;
        nArray[127] = 626;
        nArray[128] = 627;
        nArray[129] = 627;
        nArray[130] = 628;
        nArray[131] = 628;
        nArray[132] = 629;
        nArray[133] = 629;
        nArray[134] = 640;
        nArray[135] = 649;
        nArray[136] = 690;
        nArray[137] = 695;
        nArray[138] = 700;
        nArray[139] = 709;
        nArray[140] = 729;
        nArray[141] = 729;
        nArray[142] = 730;
        nArray[143] = 739;
        nArray[144] = 740;
        nArray[145] = 740;
        nArray[146] = 741;
        nArray[147] = 741;
        nArray[148] = 742;
        nArray[149] = 742;
        nArray[150] = 743;
        nArray[151] = 743;
        nArray[152] = 744;
        nArray[153] = 744;
        nArray[154] = 745;
        nArray[155] = 745;
        nArray[156] = 746;
        nArray[157] = 746;
        nArray[158] = 750;
        nArray[159] = 750;
        nArray[160] = 754;
        nArray[161] = 755;
        nArray[162] = 759;
        nArray[163] = 759;
        nArray[164] = 760;
        nArray[165] = 769;
        nArray[166] = 770;
        nArray[167] = 771;
        nArray[168] = 773;
        nArray[169] = 773;
        nArray[170] = 775;
        nArray[171] = 775;
        nArray[172] = 777;
        nArray[173] = 777;
        nArray[174] = 779;
        nArray[175] = 779;
        nArray[176] = 780;
        nArray[177] = 780;
        nArray[178] = 784;
        nArray[179] = 784;
        nArray[180] = 786;
        nArray[181] = 786;
        nArray[182] = 789;
        nArray[183] = 790;
        nArray[184] = 800;
        nArray[185] = 839;
        nArray[186] = 840;
        nArray[187] = 849;
        nArray[188] = 850;
        nArray[189] = 850;
        nArray[190] = 858;
        nArray[191] = 858;
        nArray[192] = 859;
        nArray[193] = 859;
        nArray[194] = 860;
        nArray[195] = 860;
        nArray[196] = 865;
        nArray[197] = 865;
        nArray[198] = 867;
        nArray[199] = 867;
        nArray[200] = 868;
        nArray[201] = 869;
        nArray[202] = 870;
        nArray[203] = 879;
        nArray[204] = 880;
        nArray[205] = 880;
        nArray[206] = 884;
        nArray[207] = 884;
        nArray[208] = 885;
        nArray[209] = 885;
        nArray[210] = 888;
        nArray[211] = 888;
        nArray[212] = 890;
        nArray[213] = 890;
        nArray[214] = 893;
        nArray[215] = 893;
        nArray[216] = 896;
        nArray[217] = 896;
        nArray[218] = 899;
        nArray[219] = 899;
        nArray[220] = 900;
        nArray[221] = 919;
        nArray[222] = 930;
        nArray[223] = 939;
        nArray[224] = 940;
        nArray[225] = 949;
        nArray[226] = 950;
        nArray[227] = 950;
        nArray[228] = 955;
        nArray[229] = 955;
        nArray[230] = 958;
        nArray[231] = 958;
        nArray[232] = 977;
        nArray[233] = 977;
        nArray[234] = 978;
        nArray[235] = 979;
        nArray[236] = 980;
        nArray[237] = 980;
        nArray[238] = 981;
        nArray[239] = 983;
        nArray[240] = 990;
        nArray[241] = 999;
        int[] countrys = nArray;
        boolean found = false;
        int index = 0;
        while (index < countrys.length) {
            if (countrys[index] <= country && countrys[index + 1] >= country) {
                found = true;
                break;
            }
            index += 2;
        }
        if (!found) {
            ZxingP5Com.logout(String.format("\u5148\u982d3\u6587\u5b57\u306e\u56fd\u30b3\u30fc\u30c9\u304c\u4e0d\u6b63\u3067\u3059\u3002country = %d", country));
            return false;
        }
        return true;
    }

    static String nw7AppendCheckDegit(String src) {
        String code = "";
        String orgDegit = "";
        String degit = "*";
        if (src.length() > 3) {
            code = src.substring(0, src.length() - 2);
            orgDegit = src.substring(src.length() - 2, src.length() - 1);
            degit = ZxingP5Com.nw7GetCheckDegit(code);
        } else {
            code = src.substring(0, src.length() - 1);
        }
        String last = src.substring(src.length() - 1, src.length());
        String retStr = "";
        if (!orgDegit.equals(degit)) {
            degit = ZxingP5Com.nw7GetCheckDegit(String.valueOf(code) + last);
            retStr = String.valueOf(code) + degit + last;
        } else {
            retStr = src;
        }
        return retStr;
    }

    static String nw7GetCheckDegit(String src) {
        String[] codeList = new String[]{"0", "0", "1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "-", "10", "$", "11", ":", "12", "/", "13", ".", "14", "+", "15", "A", "16", "B", "17", "C", "18", "D", "19"};
        int sum = 0;
        int index = 0;
        while (index < src.length()) {
            String code = src.substring(index, index + 1);
            int i = 0;
            while (i < codeList.length) {
                if (code.equals(codeList[i])) {
                    sum += Integer.valueOf(codeList[i + 1]).intValue();
                    break;
                }
                i += 2;
            }
            ++index;
        }
        int degitNum = 0;
        int amari = sum % 16;
        if (amari != 0) {
            degitNum = 16 - amari;
        }
        String degit = "";
        int i = 0;
        while (i < codeList.length) {
            if (String.valueOf(degitNum).equals(codeList[i + 1])) {
                degit = codeList[i];
                break;
            }
            i += 2;
        }
        return degit;
    }

    static PImage appendCodeImage(PApplet app, PImage pImage, String src, BarcodeFormat format, boolean ... appBar) {
        Object reader;
        int fontSize = 1;
        fontSize = pImage.width < pImage.height ? pImage.height / 14 : pImage.width / 14;
        String codeText = "";
        String CodeName = "";
        if (format == BarcodeFormat.EAN_13) {
            CodeName = "EAN13:";
            reader = new EANReader(app);
            codeText = ((EANReader)reader).decode13(pImage);
        } else if (format == BarcodeFormat.EAN_8) {
            CodeName = "EAN8:";
            reader = new EANReader(app);
            codeText = ((EANReader)reader).decode8(pImage);
        } else if (format == BarcodeFormat.CODABAR) {
            CodeName = "NW7:";
            reader = new NW7Reader(app);
            codeText = ((NW7Reader)reader).decode(pImage);
            String startTxt = src.substring(0, 1);
            String endTxt = src.substring(src.length() - 1, src.length());
            codeText = String.valueOf(startTxt) + codeText + endTxt;
        } else if (format == BarcodeFormat.CODE_39) {
            CodeName = "Code39:";
            codeText = "*" + src + "*";
        } else if (format == BarcodeFormat.CODE_128) {
            CodeName = "Code128:";
            codeText = src;
        } else if (format == BarcodeFormat.ITF) {
            CodeName = "ITF:";
            codeText = src;
        }
        if (format == BarcodeFormat.ITF) {
            boolean addBar = false;
            addBar = appBar.length == 0 ? true : appBar[0];
            if (addBar) {
                int barWidth = 0;
                barWidth = pImage.width < pImage.height ? pImage.width / 12 : pImage.height / 12;
                if (barWidth < 4) {
                    barWidth = 4;
                }
                PGraphics g = app.createGraphics(pImage.width + barWidth * 2, pImage.height + barWidth * 2);
                g.beginDraw();
                g.background(255);
                g.image(pImage, (float)barWidth, (float)barWidth);
                g.strokeWeight((float)barWidth);
                g.stroke(0);
                g.noFill();
                g.rect((float)(barWidth / 2), (float)(barWidth / 2), (float)(pImage.width + barWidth), (float)(pImage.height + barWidth));
                g.endDraw();
                pImage = g.get();
            }
        }
        PGraphics g = app.createGraphics(pImage.width, pImage.height + fontSize + 8);
        g.beginDraw();
        g.background(255);
        g.image(pImage, 0.0f, 0.0f);
        g.textSize((float)fontSize);
        g.textAlign(37, 101);
        g.fill(0);
        int txtStart = (int)(((float)pImage.width - g.textWidth(String.valueOf(CodeName) + codeText)) / 2.0f);
        g.text(String.valueOf(CodeName) + codeText, (float)txtStart, (float)(pImage.height + 8));
        g.endDraw();
        return g.get();
    }

    static String eanDeleteCheckDegit(String src) {
        String retStr = "";
        retStr = src.length() == 13 || src.length() == 8 ? src.substring(0, src.length() - 1) : src;
        return retStr;
    }

    static boolean checkNW7Param(String src, int width, int height) {
        if (width < 0 || height < 0) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306f0\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002width = %d  height = %d", width, height));
            return false;
        }
        if (src.length() < 3) {
            ZxingP5Com.logout(String.format("\u6587\u5b57\u6570\u304c\u4e0d\u6b63\u3067\u3059 src = %s", src));
            return false;
        }
        String startTxt = src.substring(0, 1);
        String endTxt = src.substring(src.length() - 1, src.length());
        String codeTxt = src.substring(1, src.length() - 1);
        if (!startTxt.toUpperCase().matches("[A-D]")) {
            ZxingP5Com.logout(String.format("START\u6587\u5b57\u304cABCD\u306e\u4f55\u308c\u304b\u3067\u306f\u3042\u308a\u307e\u305b\u3093 startTxt = %s", startTxt));
            return false;
        }
        if (!endTxt.toUpperCase().matches("[A-D]")) {
            ZxingP5Com.logout(String.format("STOP\u6587\u5b57\u304cABCD\u306e\u4f55\u308c\u304b\u3067\u306f\u3042\u308a\u307e\u305b\u3093 endTxt = %s", endTxt));
            return false;
        }
        if (!codeTxt.matches("^[0-9$:/.+-]+$")) {
            ZxingP5Com.logout(String.format("NW7\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308a\u307e\u3059\u3002src = %s", endTxt));
            return false;
        }
        return true;
    }

    static boolean checkITFParam(String src, int width, int height) {
        if (height < 0) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u9ad8\u3055\u306f0\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002height = %d", height));
            return false;
        }
        if (src.length() != 5 && src.length() != 6 && src.length() < 13 && src.length() > 16) {
            ZxingP5Com.logout(String.format("\u6587\u5b57\u306e\u9577\u3055\u304c\u4e0d\u6b63\u3067\u3059\u3002src = %s", src));
            return false;
        }
        if (src.length() < 7) {
            if (width < 90) {
                ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u306f90\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002width = %d", width));
                return false;
            }
        } else if (src.length() < 15) {
            if (width < 160) {
                ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u306f160\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002width = %d", width));
                return false;
            }
        } else if (width < 180) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u306f180\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002width = %d", width));
            return false;
        }
        if (!src.matches("^[0-9]+$")) {
            ZxingP5Com.logout(String.format("ITF\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308a\u307e\u3059\u3002src = %s", src));
            return false;
        }
        return true;
    }

    static String itfAppendCheckDegit(String src) {
        String code = src;
        String orgDegit = "";
        String degit = "*";
        if (src.length() == 6 || src.length() == 14 || src.length() == 16) {
            code = src.substring(0, src.length() - 1);
            orgDegit = src.substring(src.length() - 1, src.length());
            degit = ZxingP5Com.itfGetCheckDegit(code);
        }
        String retStr = "";
        if (!orgDegit.equals(degit)) {
            degit = ZxingP5Com.itfGetCheckDegit(code);
            retStr = String.valueOf(code) + degit;
        } else {
            retStr = src;
        }
        return retStr;
    }

    static String itfGetCheckDegit(String src) {
        int gsum = 0;
        int index = 0;
        while (index < src.length()) {
            gsum += Integer.valueOf(src.substring(index, index + 1)).intValue();
            index += 2;
        }
        gsum *= 3;
        int ksum = 0;
        int index2 = 1;
        while (index2 < src.length()) {
            ksum += Integer.valueOf(src.substring(index2, index2 + 1)).intValue();
            index2 += 2;
        }
        int sum = ksum + gsum;
        int lastNum = 0;
        lastNum = sum > 100 ? sum % 100 % 10 : sum % 10;
        int degit = 0;
        if (lastNum > 0) {
            degit = 10 - lastNum;
        }
        return String.valueOf(degit);
    }

    static String code39AppendDeleteCheckDegit(String src, boolean degitFlg) {
        String startTxt = src.substring(0, 1);
        if (startTxt.equals("*")) {
            src = src.substring(1, src.length() - 1);
        }
        String check = src.substring(0, src.length() - 1);
        String degit = ZxingP5Com.code39GetCheckDegit(check);
        String retStr = "";
        retStr = degitFlg ? String.valueOf(check) + degit : src;
        return retStr;
    }

    static String code39GetCheckDegit(String src) {
        int i;
        String[] codeList = new String[]{"0", "0", "1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "A", "10", "B", "11", "C", "12", "D", "13", "E", "14", "F", "15", "G", "16", "H", "17", "I", "18", "J", "19", "K", "20", "L", "21", "M", "22", "N", "23", "O", "24", "P", "25", "Q", "26", "R", "27", "S", "28", "T", "29", "U", "30", "V", "31", "W", "32", "X", "33", "Y", "34", "Z", "35", "-", "36", ".", "37", " ", "38", "$", "39", "/", "40", "+", "41", "%", "42"};
        String startTxt = src.substring(0, 1);
        String codeTxt = src.substring(1, src.length() - 1);
        String checkSrc = "";
        checkSrc = startTxt.equals("*") ? codeTxt : src;
        int sum = 0;
        int index = 0;
        while (index < checkSrc.length()) {
            String code = checkSrc.substring(index, index + 1);
            i = 0;
            while (i < codeList.length) {
                if (code.equals(codeList[i])) {
                    sum += Integer.valueOf(codeList[i + 1]).intValue();
                    break;
                }
                i += 2;
            }
            ++index;
        }
        int degitNum = sum % 43;
        String degit = "";
        i = 0;
        while (i < codeList.length) {
            if (String.valueOf(degitNum).equals(codeList[i + 1])) {
                degit = codeList[i];
                break;
            }
            i += 2;
        }
        return degit;
    }

    static boolean checkCodeParam(BarcodeFormat format, String src, int width, int height) {
        if (width < 0 || height < 0) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306f0\u4ee5\u4e0a\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002width = %d  height = %d", width, height));
            return false;
        }
        if (format != BarcodeFormat.CODE_39 && format != BarcodeFormat.CODE_128) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002", new Object[0]));
            return false;
        }
        if (src.length() < 1) {
            ZxingP5Com.logout(String.format("\u5909\u63db\u5bfe\u8c61\u6587\u5b57\u5217\u304c\u4e0d\u6b63\u3067\u3059\u3002", new Object[0]));
            return false;
        }
        if (format == BarcodeFormat.CODE_39) {
            if (src.length() > 2) {
                String startTxt = src.substring(0, 1);
                String endTxt = src.substring(src.length() - 1, src.length());
                if (startTxt.equals("*") && !endTxt.equals("*")) {
                    ZxingP5Com.logout(String.format("START\u6587\u5b57\u306b\u5bfe\u5fdc\u3059\u308bSTOP\u6587\u5b57\u304c\u3042\u308a\u307e\u305b\u3093\u3002src = %s", src));
                    return false;
                }
            }
            if (!src.toUpperCase().matches("^[A-Z0-9. $/+%*]+$")) {
                ZxingP5Com.logout(String.format("Code39\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308a\u307e\u3059\u3002src = %s", src));
                return false;
            }
        } else if (!src.matches("^[\\x20-\\x7F]+$")) {
            ZxingP5Com.logout(String.format("Code128\u3067\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u304c\u3042\u308a\u307e\u3059\u3002src = %s", src));
            return false;
        }
        return true;
    }

    public static String getVersion() {
        return VERSION;
    }
}

