/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;

public class QRWriter {
    private QRCodeWriter writer = new QRCodeWriter();
    private PImage rowImage;
    private BitMatrix bitMatrix;
    private ErrorCorrectionLevel ecLevel = ErrorCorrectionLevel.M;
    private String charSet = "Shift_JIS";
    private int CodeVersion = 0;
    private PApplet app;
    public static final String VERSION = "1.0.1";

    public QRWriter(PApplet applet) {
        this.app = applet;
    }

    public boolean setEcLevel(ErrorCorrectionLevel ec) {
        if (ec != ErrorCorrectionLevel.H && ec != ErrorCorrectionLevel.L && ec != ErrorCorrectionLevel.M && ec != ErrorCorrectionLevel.Q) {
            ZxingP5Com.logout(String.format("\u8aa4\u308a\u8a02\u6b63\u7387 \u5f15\u6570\u4e0d\u6b63", new Object[0]));
            return false;
        }
        this.ecLevel = ec;
        return true;
    }

    public ErrorCorrectionLevel getEcLevel() {
        return this.ecLevel;
    }

    public int getQrVersion(String ... src) {
        if (src.length != 0) {
            this.CodeVersion = ZxingP5Com.getQrVersion(src[0], this.ecLevel);
        }
        return this.CodeVersion;
    }

    public PImage encode(String src, int ... version) {
        this.CodeVersion = 0;
        if (version.length == 0) {
            this.CodeVersion = ZxingP5Com.getQrVersion(src, this.ecLevel);
            if (this.CodeVersion == 0) {
                ZxingP5Com.logout(String.format("QR\u30d0\u30fc\u30b8\u30e7\u30f3\u53d6\u5f97\u5931\u6557 src = %s", src));
                return null;
            }
        } else {
            this.CodeVersion = version[0];
            if (!ZxingP5Com.checkQRParam(src, this.ecLevel, this.CodeVersion)) {
                ZxingP5Com.logout(String.format("\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63", new Object[0]));
                return null;
            }
        }
        int size = 21 + this.CodeVersion * 4;
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.QR_VERSION, this.CodeVersion);
        hints.put(EncodeHintType.CHARACTER_SET, this.charSet);
        hints.put(EncodeHintType.ERROR_CORRECTION, this.ecLevel);
        hints.put(EncodeHintType.MARGIN, 4);
        try {
            this.bitMatrix = this.writer.encode(src, BarcodeFormat.QR_CODE, size, size, hints);
        }
        catch (WriterException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067\u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        this.rowImage = ZxingP5Com.changeBitMatrix2PImage(this.bitMatrix);
        return this.rowImage;
    }

    public PImage resize(int width, int height) {
        if (width < 25 || height < 25) {
            ZxingP5Com.logout(String.format("\u753b\u50cf\u306e\u9ad8\u3055\u3068\u5e45\u304c\u4e0d\u6b63 width = %d  height = %d", width, height));
            return null;
        }
        PImage pImage = null;
        if (this.rowImage != null) {
            pImage = ZxingP5Com.resizeImage(this.rowImage, width, height);
        }
        return pImage;
    }

    public PImage getImage() {
        return this.rowImage;
    }

    public static String getVersion() {
        return VERSION;
    }
}

