/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import processing.core.PApplet;
import processing.core.PImage;

public class CodeWriter {
    private Code39Writer writer39 = new Code39Writer();
    private Code128Writer writer128 = new Code128Writer();
    private PImage rowImage;
    private BitMatrix bitMatrix;
    private PApplet app;
    public static final String VERSION = "1.0.0";

    public CodeWriter(PApplet applet) {
        this.app = applet;
    }

    public PImage resize(int width, int height) {
        PImage pImage = null;
        if (this.rowImage != null) {
            pImage = ZxingP5Com.resizeImage(this.rowImage, width, height);
        }
        return pImage;
    }

    public PImage encode(String src, BarcodeFormat format, int width, int height, boolean appFont, boolean ... appDegit) {
        if (!ZxingP5Com.checkCodeParam(format, src, width, height)) {
            ZxingP5Com.logout(String.format("\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63", new Object[0]));
            return null;
        }
        try {
            if (format == BarcodeFormat.CODE_39) {
                String startTxt = src.substring(0, 1);
                if (startTxt.equals("*")) {
                    src = src.substring(1, src.length() - 1);
                }
                src = appDegit.length == 0 ? ZxingP5Com.code39AppendDeleteCheckDegit(src.toUpperCase(), false) : ZxingP5Com.code39AppendDeleteCheckDegit(src.toUpperCase(), appDegit[0]);
                this.bitMatrix = this.writer39.encode(src.toUpperCase(), format, width, height);
            } else {
                this.bitMatrix = this.writer128.encode(src, format, width, height);
            }
        }
        catch (WriterException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067 WriterException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        catch (IllegalArgumentException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067 IllegalArgumentException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        this.rowImage = ZxingP5Com.changeBitMatrix2PImage(this.bitMatrix);
        PImage pImage = this.rowImage.copy();
        if (appFont) {
            pImage = ZxingP5Com.appendCodeImage(this.app, this.rowImage, src, format, new boolean[0]);
        }
        return pImage;
    }

    public PImage encode128(String src, int width, int height, boolean appFont) {
        return this.encode(src, BarcodeFormat.CODE_128, width, height, appFont, false);
    }

    public PImage encode39(String src, int width, int height, boolean appFont, boolean ... appDegit) {
        return this.encode(src, BarcodeFormat.CODE_39, width, height, appFont, appDegit);
    }

    public PImage getImage() {
        return this.rowImage;
    }

    public static String getVersion() {
        return VERSION;
    }
}

