/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.CodaBarWriter;
import processing.core.PApplet;
import processing.core.PImage;

public class NW7Writer {
    private CodaBarWriter writer = new CodaBarWriter();
    private PImage rowImage;
    private BitMatrix bitMatrix;
    private PApplet app;
    public static final String VERSION = "1.0.0";

    public NW7Writer(PApplet applet) {
        this.app = applet;
    }

    public PImage resize(int width, int height) {
        PImage pImage = null;
        if (this.rowImage != null) {
            pImage = ZxingP5Com.resizeImage(this.rowImage, width, height);
        }
        return pImage;
    }

    public PImage encode(String src, int width, int height, boolean ... appFont) {
        if (!ZxingP5Com.checkNW7Param(src, width, height)) {
            ZxingP5Com.logout(String.format("\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63", new Object[0]));
            return null;
        }
        String targer = ZxingP5Com.nw7AppendCheckDegit(src.toUpperCase());
        try {
            this.bitMatrix = this.writer.encode(targer.toUpperCase(), BarcodeFormat.CODABAR, width, height);
        }
        catch (WriterException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067\u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        this.rowImage = ZxingP5Com.changeBitMatrix2PImage(this.bitMatrix);
        PImage pImage = this.rowImage.copy();
        if (appFont.length > 0 && appFont[0]) {
            pImage = ZxingP5Com.appendCodeImage(this.app, this.rowImage, targer.toUpperCase(), BarcodeFormat.CODABAR, new boolean[0]);
        }
        return pImage;
    }

    public PImage getImage() {
        return this.rowImage;
    }

    public static String getVersion() {
        return VERSION;
    }
}

