/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.oned.ITFReader;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class ITFP5Reader {
    private ITFReader reader = new ITFReader();
    private Result result = null;
    private PApplet app;
    private int rotateDegree;
    public static final String VERSION = "1.0.0";

    public ITFP5Reader(PApplet applet) {
        this.app = applet;
        this.rotateDegree = 10;
    }

    public void setRotateDegree(int degree) {
        if (degree > 0 && degree < 181) {
            this.rotateDegree = degree;
        }
    }

    public int getRotateDegree() {
        return this.rotateDegree;
    }

    Result decodeRow(BinaryBitmap bitmap) {
        this.result = null;
        HashMap<DecodeHintType, Boolean> hints = new HashMap<DecodeHintType, Boolean>();
        hints.put(DecodeHintType.TRY_HARDER, true);
        try {
            this.result = this.reader.decode(bitmap, hints);
        }
        catch (NotFoundException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u8aad\u307f\u53d6\u308a NotFoundException \u4f8b\u5916\u767a\u751f", new Object[0]));
        }
        catch (FormatException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u8aad\u307f\u53d6\u308a FormatException \u4f8b\u5916\u767a\u751f", new Object[0]));
        }
        return this.result;
    }

    public String decode(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        PImage copyImage = pImage.copy();
        int degree = 0;
        while (degree <= 180) {
            BinaryBitmap bitmap = ZxingP5Com.changePImage2Bitmap(copyImage, globalHistogram);
            this.decodeRow(bitmap);
            if (this.result != null && this.result.getText() != null) {
                return this.result.getText();
            }
            if (doRotate.length <= 0 || !doRotate[0]) break;
            ZxingP5Com.logout(String.format("\u753b\u50cf\u3092 %d \u5ea6\u56de\u8ee2\u3057\u3066\u3001\u518d\u5ea6\u8aad\u307f\u53d6\u308a\u307e\u3059", degree));
            copyImage = ZxingP5Com.codeImageRotate(this.app, pImage, degree);
            degree += this.rotateDegree;
        }
        return null;
    }

    public String decode(PImage pImage) {
        return this.decode(pImage, true, false);
    }

    public PVector[] getPoints() {
        return ZxingP5Com.getPoints(this.result);
    }

    public Result getResult() {
        return this.result;
    }

    public static String getVersion() {
        return VERSION;
    }
}

