/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import processing.core.PApplet;
import processing.core.PImage;

public class EANWriter {
    private EAN13Writer writer13 = new EAN13Writer();
    private EAN8Writer writer8 = new EAN8Writer();
    private PImage rowImage;
    private BitMatrix bitMatrix;
    private PApplet app;
    public static final String VERSION = "1.0.0";

    public EANWriter(PApplet applet) {
        this.app = applet;
    }

    public PImage resize(int width, int height) {
        PImage pImage = null;
        if (this.rowImage != null) {
            pImage = ZxingP5Com.resizeImage(this.rowImage, width, height);
        }
        return pImage;
    }

    public PImage encode(String src, BarcodeFormat format, int width, int height, boolean ... appFont) {
        if (!ZxingP5Com.checkEANParam(format, src, width, height)) {
            ZxingP5Com.logout(String.format("\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63", new Object[0]));
            return null;
        }
        src = ZxingP5Com.eanDeleteCheckDegit(src);
        try {
            this.bitMatrix = format == BarcodeFormat.EAN_13 ? this.writer13.encode(src, format, width, height) : this.writer8.encode(src, format, width, height);
        }
        catch (WriterException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067 WriterException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        catch (IllegalArgumentException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u751f\u6210\u3067 IllegalArgumentException \u4f8b\u5916\u767a\u751f", new Object[0]));
            return null;
        }
        this.rowImage = ZxingP5Com.changeBitMatrix2PImage(this.bitMatrix);
        PImage pImage = this.rowImage.copy();
        if (appFont.length > 0 && appFont[0]) {
            pImage = ZxingP5Com.appendCodeImage(this.app, this.rowImage, src, format, new boolean[0]);
        }
        return pImage;
    }

    public PImage encode13(String src, int width, int height, boolean ... appFont) {
        return this.encode(src, BarcodeFormat.EAN_13, width, height, appFont);
    }

    public PImage encode8(String src, int width, int height, boolean ... appFont) {
        return this.encode(src, BarcodeFormat.EAN_8, width, height, appFont);
    }

    public PImage getImage() {
        return this.rowImage;
    }

    public static String getVersion() {
        return VERSION;
    }
}

