/*
 * Decompiled with CFR 0.152.
 */
package ZxingP5;

import ZxingP5.ZxingP5Com;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class CodeReader {
    private Code39Reader reader39 = new Code39Reader();
    private Code128Reader reader128 = new Code128Reader();
    private Result result = null;
    private PApplet app;
    private int rotateDegree;
    public static final String VERSION = "1.0.0";

    public CodeReader(PApplet applet) {
        this.app = applet;
        this.rotateDegree = 10;
    }

    public void setRotateDegree(int degree) {
        if (degree > 0 && degree < 181) {
            this.rotateDegree = degree;
        }
    }

    public int getRotateDegree() {
        return this.rotateDegree;
    }

    Result decodeRow(BarcodeFormat format, BinaryBitmap bitmap) {
        this.result = null;
        HashMap<DecodeHintType, Boolean> hints = new HashMap<DecodeHintType, Boolean>();
        hints.put(DecodeHintType.TRY_HARDER, true);
        try {
            this.result = format == BarcodeFormat.CODE_39 ? this.reader39.decode(bitmap, hints) : this.reader128.decode(bitmap, hints);
        }
        catch (NotFoundException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u8aad\u307f\u53d6\u308a NotFoundException \u4f8b\u5916\u767a\u751f", new Object[0]));
        }
        catch (FormatException e) {
            ZxingP5Com.logout(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u8aad\u307f\u53d6\u308a FormatException \u4f8b\u5916\u767a\u751f", new Object[0]));
        }
        return this.result;
    }

    public String decode39(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        this.decode39Byte(pImage, globalHistogram, doRotate);
        if (this.result != null) {
            return this.result.getText();
        }
        return null;
    }

    public String decode39(PImage pImage) {
        return this.decode39(pImage, true, false);
    }

    public byte[] decode39Byte(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        PImage copyImage = pImage.copy();
        int degree = 0;
        while (degree <= 180) {
            BinaryBitmap bitmap = ZxingP5Com.changePImage2Bitmap(copyImage, globalHistogram);
            this.decodeRow(BarcodeFormat.CODE_39, bitmap);
            if (this.result != null) {
                return this.result.getText().getBytes();
            }
            if (doRotate.length <= 0 || !doRotate[0]) break;
            ZxingP5Com.logout(String.format("\u753b\u50cf\u3092 %d \u5ea6\u56de\u8ee2\u3057\u3066\u3001\u518d\u5ea6\u8aad\u307f\u53d6\u308a\u307e\u3059", degree));
            copyImage = ZxingP5Com.codeImageRotate(this.app, pImage, degree);
            degree += this.rotateDegree;
        }
        return null;
    }

    public byte[] decode39Byte(PImage pImage) {
        return this.decode39Byte(pImage, true, false);
    }

    public String decode128(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        this.decode128Byte(pImage, globalHistogram, doRotate);
        if (this.result != null) {
            return this.result.getText();
        }
        return null;
    }

    public String decode128(PImage pImage) {
        return this.decode128(pImage, true, false);
    }

    public byte[] decode128Byte(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        PImage copyImage = pImage.copy();
        int degree = 0;
        while (degree <= 180) {
            BinaryBitmap bitmap = ZxingP5Com.changePImage2Bitmap(copyImage, globalHistogram);
            this.decodeRow(BarcodeFormat.CODE_128, bitmap);
            if (this.result != null) {
                return this.result.getRawBytes();
            }
            if (doRotate.length <= 0 || !doRotate[0]) break;
            ZxingP5Com.logout(String.format("\u753b\u50cf\u3092 %d \u5ea6\u56de\u8ee2\u3057\u3066\u3001\u518d\u5ea6\u8aad\u307f\u53d6\u308a\u307e\u3059", degree));
            copyImage = ZxingP5Com.codeImageRotate(this.app, pImage, degree);
            degree += this.rotateDegree;
        }
        return null;
    }

    public byte[] decode128Byte(PImage pImage) {
        return this.decode128Byte(pImage, true, false);
    }

    public String decode(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        String retText = this.decode39(pImage, globalHistogram, doRotate);
        if (retText == null) {
            ZxingP5Com.logout("Code39\u3067\u306f\u7121\u3055\u305d\u3046\u3067\u3059\u3002Code128\u3068\u3057\u3066\u8aad\u307f\u53d6\u308a\u307e\u3059\u3002");
            retText = this.decode128(pImage, globalHistogram, doRotate);
        }
        return retText;
    }

    public String decode(PImage pImage) {
        return this.decode(pImage, true, false);
    }

    public byte[] decodeByte(PImage pImage, boolean globalHistogram, boolean ... doRotate) {
        byte[] retByte = this.decode39Byte(pImage, globalHistogram, doRotate);
        if (retByte == null) {
            ZxingP5Com.logout(String.format("Code39\u3067\u306f\u7121\u3055\u305d\u3046\u3067\u3059\u3002Code128\u3068\u3057\u3066\u8aad\u307f\u53d6\u308a\u307e\u3059\u3002", new Object[0]));
            retByte = this.decode128Byte(pImage, globalHistogram, doRotate);
        }
        return retByte;
    }

    public byte[] decodeByte(PImage pImage) {
        return this.decodeByte(pImage, true, new boolean[0]);
    }

    public PVector[] getPoints() {
        return ZxingP5Com.getPoints(this.result);
    }

    public Result getResult() {
        return this.result;
    }

    public static String getVersion() {
        return VERSION;
    }
}

