//********************************************************
// Windows SAPI R[Cu
//------------------------------------------------------------------------
// CopyRight : MSLABO  Ver1.0
//********************************************************
// l̖
// {vOƃhLgiȉA{APƌď́j̒쌠MSLABOɂ܂B
//
// {AṔAȉ̃NGBeBuERYCZXɏ]񋟂Ă܂B
// https://creativecommons.org/licenses/by-sa/4.0/
//
// pɂẮAKȐӔCł肢v܂B
//
// {AP̕sɂĂ͋ɗ͑Ps\łAۏ؂̂ł͂܂B
// ܂{APɊւׂ͂MSLABOHPIɌĴƂAƂ
// ʂ̖₢킹v]͎󂯕t܂B
//
// LɓӒ̂݁Ap\łB
//
// fڐF
// URL : http://mslabo.sakura.ne.jp/WordPress/
//
// {vOA݂Ȃ܂PROCESSINGp̈ꏕɂȂ΍KłB
//
//***********************************************************

#pragma once
#include <msclr/marshal.h>
#include <msclr/marshal_cppstd.h>
#include "stdafx.h"
#include <Windows.h>
#include <conio.h>

using namespace System;
using namespace msclr::interop;
using namespace System::Reflection;
using namespace System::Speech::Synthesis;
using namespace System::Threading;
using namespace System::Reflection;


namespace ClassLibrary1 {
	//DLLÓIϐ
	public ref class Class1 {
		public: static SpeechSynthesizer ^_synte;	//VZTCU[
		public: static String  ^_culture;			//ꃍ[J
	};
}

//*******************************************************************
//VZTCU[
//-------------------------------------------------------------------
// IN : wchar_t *fileName	WAVt@CpX
//*******************************************************************
extern "C" __declspec(dllexport) int createSynthesizer(wchar_t *fileName)
{
	ClassLibrary1::Class1 work;

	work._synte = nullptr;
	work._synte = gcnew SpeechSynthesizer();
	if ( work._synte == nullptr ) {
		//s
		System::Console::Error->WriteLine("createSynthesizer:SpeechSynthesizer create error.\n");
		return(-99);
	}

	//printf("createSynthesizer:SpeechSynthesizer create start.\n");
	if (fileName == NULL || wcslen(fileName) < 1) {
		//WfoCXɏo
		work._synte->SetOutputToDefaultAudioDevice();
	}
	else {
		//WAVt@Cɏo
		System::String^ s1 = marshal_as<System::String^>(fileName);
		work._synte->SetOutputToWaveFile(s1);
	}

	work._culture = work._synte->Voice->Culture->Name;
	
	//std::string s_cpp = marshal_as<std::string>(work._synte->Voice->Culture->Name);
	//printf("%s\n", s_cpp.c_str());
	//printf("createSynthesizer:SpeechSynthesizer create done.\n");
	return(0);
}

//*******************************************************************
//ǂݏグxݒ
//-------------------------------------------------------------------
// IN : int speed	x(-10 ` 10)
//*******************************************************************
extern "C" __declspec(dllexport) void setSpeed(int speed)
{
	ClassLibrary1::Class1 work;
	if (speed < -10 || speed > 10) {
		//͈͊OG[
		System::Console::Error->WriteLine("setSpeed:Irregular Argument.\n");
		return;
	}

	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("setSpeed:SpeechSynthesizer not created.\n");
		return;
	}

	work._synte->Rate = speed;
	return;
}

//*******************************************************************
//ʐݒ
//-------------------------------------------------------------------
// IN : int vol	(0 ` 100)
//*******************************************************************
extern "C" __declspec(dllexport) void setVolume(int vol)
{
	ClassLibrary1::Class1 work;
	if (vol < 0 || vol > 100) {
		//͈͊OG[
		System::Console::Error->WriteLine("setVolume:Irregular Argument.\n");
		return;
	}

	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("setVolume:SpeechSynthesizer not created.\n");
		return;
	}

	work._synte->Volume = vol;
	return;
}

//*******************************************************************
// String^ -> char* ϊ
//*******************************************************************
char * change(String ^ss) {
	pin_ptr<const wchar_t> wch = PtrToStringChars(ss);

	size_t convertedChars = 0;
	size_t  sizeInBytes = ((ss->Length + 1) * 2);
	errno_t err = 0;
	char    *ch = (char *)calloc(1, sizeInBytes);

	err = wcstombs_s(&convertedChars,
		ch, sizeInBytes,
		wch, sizeInBytes);
	if (err != 0)
		System::Console::Error->WriteLine("change:wcstombs_s  failed!\n");

	return(ch);
}

//*******************************************************************
//f[^w
//-------------------------------------------------------------------
// IN : char *voice	 f[^
//*******************************************************************
extern "C" __declspec(dllexport) int setVoice(wchar_t *voice)
{
	ClassLibrary1::Class1 work;

	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("setVoice:SpeechSynthesizer not created.\n");
		return(-99);
	}

	//w肳ꂽOSɓo^ς݂
	System::Collections::ObjectModel::ReadOnlyCollection<InstalledVoice^> ^voices;
	voices = work._synte->GetInstalledVoices();

	bool found = false;
	int  index = 0;

	System::String^ sv = marshal_as<System::String^>(voice);

	for (index = 0; index < voices->Count; index++) {

		String ^gv = voices[index]->VoiceInfo->Name;

		//printf("[%s] [%s]\n", change(gv), change(sv));

		if(gv->IndexOf(sv) > -1 ){
			//
			found = true;
			break;
		}
	}

	if (found == false) {
		//OSo^
		System::Console::Error->WriteLine("setVoice:voice name is not found\n");
		return (-99);
	}

	work._synte->SelectVoice(voices[index]->VoiceInfo->Name);
	work._culture = voices[index]->VoiceInfo->Culture->Name;

	//std::string s_cpp = marshal_as<std::string>(work._synte->Voice->Culture->Name);
	//printf("%s\n", s_cpp.c_str());
	return(0);
}

//*******************************************************************
//ǂݏグx擾
//-------------------------------------------------------------------
// return : int		x
//*******************************************************************
extern "C" __declspec(dllexport) int getSpeed()
{
	ClassLibrary1::Class1 work;

	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("getSpeed:SpeechSynthesizer not created.\n");
		return(-99);
	}
	
	int speed = work._synte->Rate;
	return(speed);
}

//*******************************************************************
//ʓx擾
//-------------------------------------------------------------------
// return : int		
//*******************************************************************
extern "C" __declspec(dllexport) int getVolume()
{
	ClassLibrary1::Class1 work;

	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("getVolume:SpeechSynthesizer not created.\n");
		return(-99);
	}

	int volume = work._synte->Volume;
	return(volume);
}

//*******************************************************************
//f[^擾
//-------------------------------------------------------------------
// return : char  f[^
//*******************************************************************
extern "C" __declspec(dllexport) char* getVoice()
{
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("getVoice:SpeechSynthesizer not created.\n");
		return(nullptr);
	}

	//char pStr[128];
	//memset( pStr, '\0', 128 );

	//Jgf[^擾AString^ -> char*ɕϊ
	VoiceInfo ^v;
	v = work._synte->Voice;

	char    *ch = change(v->Name );

	//pin_ptr<const wchar_t> wch = PtrToStringChars(v->Name);

	//size_t convertedChars = 0;
	//size_t  sizeInBytes = ((v->Name->Length + 1) * 2);
	//errno_t err = 0;
	//char    *ch = (char *)calloc(1,sizeInBytes);

	//err = wcstombs_s(&convertedChars,
	//	ch, sizeInBytes,
	//	wch, sizeInBytes);
	//if (err != 0)
	//	System::Console::Error->WriteLine("getVoice:wcstombs_s  failed!\n");

	//printf_s("[%s]\n", ch);
	return(ch);
}

//*******************************************************************
//Ԏ擾
//-------------------------------------------------------------------
// return : int  
//*******************************************************************
extern "C" __declspec(dllexport) int getStat()
{
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("getStat:SpeechSynthesizer not created.\n");
		return(-99);
	}

	return(0);
}

//*******************************************************************
//ǂݏグʕ
//-------------------------------------------------------------------
// IN : String^    ǂݏグ镶
//    : mode       A񓯊
//*******************************************************************
void speakMsgCommon( String ^msg, bool mode ) {
	ClassLibrary1::Class1 work;

	try {
		if (mode == true) {
			//
			work._synte->Speak(msg);
		}
		else {
			//񓯊
			work._synte->SpeakAsync(msg);
		}
		
	}
	catch (...) {
		System::Console::Error->WriteLine("speakMsgCommon:speak command error.\n");
	}
}

//*******************************************************************
//ǂݏグʕ(SSML)
//-------------------------------------------------------------------
// IN : String^    ǂݏグ镶
//    : mode       A񓯊
//*******************************************************************
void speakMsgSsmlCommon(String ^msg, bool mode) {
	ClassLibrary1::Class1 work;

	//I𒆂̉ʂ擾
	String ^cu = work._culture;

	boolean unexpectedSsml = false;
	//speakƂ̂ŁASSML`ł͂ȂƂ݂Ȃ
	
	if (msg->IndexOf("<speak", System::StringComparison::CurrentCultureIgnoreCase) < 0) {
		//擪 <speak Ł@n܂ĂȂ̂SSML`ł͂ȂƌȂ
		//System::Console::Out->WriteLine("Because it is illegal SSML, we add tag automatically.\n");
		unexpectedSsml = true;
	}

	if (unexpectedSsml) {
		//Kvȏt
		String ^head1 = gcnew String("<speak xml:lang=\"");
		String ^head2 = gcnew String("\" version=\"1.0\">");
		String ^tail = gcnew String("</speak>");
		msg = head1 + cu + head2 + msg + tail;
	}

	try {
		if (mode == true) {
			//
			work._synte->SpeakSsml(msg);
		}
		else {
			//񓯊
			work._synte->SpeakSsmlAsync(msg);
		}

	}
	catch (...) {
		System::Console::Error->WriteLine("speakMsgSsmlCommon:speak command error.\n");
	}
}

//*******************************************************************
//ǂݏグ
//-------------------------------------------------------------------
// IN : wchar_t*   ǂݏグ镶
//*******************************************************************
extern  "C" __declspec(dllexport) void speakMsg(wchar_t *msg) {
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("speakMsg:SpeechSynthesizer not created.\n");
		return;
	}


	//printf("%x%x%x%x\n", msg[0], msg[1], msg[2], msg[3]);

	System::String^ s1 = marshal_as<System::String^>(msg);
	speakMsgCommon(s1, true);

	return;
}

//*******************************************************************
//񓯊ǂݏグ
//-------------------------------------------------------------------
// IN : wchar_t*   ǂݏグ镶
//*******************************************************************
extern  "C" __declspec(dllexport) void speakAsyMsg(wchar_t *msg) {
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("speakAsyMsg:SpeechSynthesizer not created.\n");
		return;
	}

	System::String^ s1 = marshal_as<System::String^>(msg);
	speakMsgCommon(s1, false);

	return;
}

//*******************************************************************
//ǂݏグ(SSML)
//-------------------------------------------------------------------
// IN : wchar_t*   ǂݏグ镶
//*******************************************************************
extern "C" __declspec(dllexport) void speakSsmlMsg(wchar_t *msg)
{
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("speakSsmlMsg:SpeechSynthesizer not created.\n");
		return;
	}

	System::String^ pmsg = marshal_as<System::String^>(msg);
	speakMsgSsmlCommon(pmsg, true);
	
	return;
}

//*******************************************************************
//񓯊ǂݏグ(SSML)
//-------------------------------------------------------------------
// IN : wchar_t*   ǂݏグ镶
//*******************************************************************
extern "C" __declspec(dllexport) void speakAsySsmlMsg(wchar_t *msg)
{
	ClassLibrary1::Class1 work;
	if (work._synte == nullptr) {
		//VZTCU[
		System::Console::Error->WriteLine("speakAsySsmlMsg:SpeechSynthesizer not created.\n");
		return;
	}

	System::String^ pmsg = marshal_as<System::String^>(msg);
	speakMsgSsmlCommon(pmsg, false);

	return;
}

//*******************************************************************
//J
//*******************************************************************
extern "C" __declspec(dllexport) void sapiDispose()
{
	ClassLibrary1::Class1 work;
	if (work._synte != nullptr) {
		try{
			work._synte->SpeakAsyncCancelAll();	
			work._synte->SetOutputToNull();
		}
		catch (...) {
			//System::Console::Error->WriteLine("SpeakAsyncCancelAll error");
		}		
		work._synte = nullptr;
	}
	return;
}
